using System;
using Server.Network;
using Server.Prompts;
using Server.Items;
using Server.Targeting;

namespace Server.Items
{
	public class Navnada : Item
	{
		[Constructable]
		public Navnada() : this( 1 )
		{
		}
      
      [Constructable]
		public Navnada( int amount ) : base( 3983 )
		{
			Weight = 0.01;
			Hue = 2582;
			Stackable = true;
			Name = "rybarska navnada";
			Amount = amount;
		}

		public Navnada( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( !IsChildOf( from.Backpack ) ) // Make sure its in their pack
			{
				from.SendLocalizedMessage( 1060640 );
			}
			else
			{
				from.SendMessage( "Na jaky magicky prut chces navnadu pouzit" );
				from.Target = new NavnadaTarget( this );
			}
		}
		
		private class NavnadaTarget : Target
		{
			private Navnada m_Deed;

			public NavnadaTarget( Navnada deed ) : base( 1, false, TargetFlags.None )
			{
				m_Deed = deed;
			}

			protected override void OnTarget( Mobile from, object target )
			{
				if ( !( target is MagicalFishingPole ) )
				{
					from.SendMessage( "Navnadu lze pouzit pouze na magicky rybarsky prut!" );
					return;
				}
				
				MagicalFishingPole fishingpole = (MagicalFishingPole) target;
					
				if ( fishingpole == null || fishingpole.Bait >= 100 )
					from.SendMessage( "Na prut lze umistit navnadu maximalne na 100 pouziti!" );
				else if( fishingpole.RootParent != from || !m_Deed.IsChildOf( from.Backpack ) )
					from.SendMessage( "Musis mit navnadu i prut u sebe" );
//             else if( fishingpole.BlessedFor != null && fishingpole.BlessedFor != from )
// 					from.SendMessage( "Toto neni tvuj prut" );
				else
				{
					int need = ( m_Deed.Amount > 100 - fishingpole.Bait ) ? 100 - fishingpole.Bait : m_Deed.Amount;
               
               fishingpole.Bait += need;
               from.FixedParticles( 14170, 1, 10, 0x1F78, m_Deed.Hue, 5, EffectLayer.Waist );
					from.PlaySound( 0x18F );
					from.SendMessage( "{0} kusu navnady bylo umisteno na prut", need );
					m_Deed.Consume( need );
				}
			}
		}
	}
}


